IF NOT EXISTS(SELECT 1 FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME=N'EST_PROD_SUPRIMENTO_ENCOMENDA')
 BEGIN
  SET ANSI_NULLS ON
  SET QUOTED_IDENTIFIER ON
  CREATE TABLE [dbo].[EST_PROD_SUPRIMENTO_ENCOMENDA](
	[CD_CTR] [bigint] IDENTITY(1,1) NOT NULL,
	[CD_EMP] [int] NOT NULL,
	[CD_USU] [int] NOT NULL,
	[DT_CAD] [datetime] NOT NULL,
	[QTDE_PROD] [money] NOT NULL,
	[CD_PROD] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[STS_UTILIZADO] [tinyint] NOT NULL DEFAULT ((0))
    CONSTRAINT [PK_EST_PROD_SUPRIMENTO_ENCOMENDA] PRIMARY KEY CLUSTERED 
	(	[CD_EMP] ASC,
		[CD_USU] ASC,
		[DT_CAD] ASC,
		[CD_PROD] ASC,
		[CD_FILIAL] ASC
	) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY]
	
	CREATE NONCLUSTERED INDEX IX_EST_PROD_SUPRIMENTO_ENCOMENDA_PROD_FILIAL ON EST_PROD_SUPRIMENTO_ENCOMENDA(CD_PROD, CD_FILIAL);
	
 END